package es.upv.dsic.issi.dplfw.core.ui.wizards.pages;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SetFileNameWizardPage extends WizardPage implements ModifyListener {
	
	private Text fileNameField;
	private String fileName;
	
	public SetFileNameWizardPage(String pageName) {
		super(pageName);
	}

	@Override
	public void createControl(Composite parent) {
	    Composite composite = new Composite(parent, SWT.NULL);
	    
	    initializeDialogUnits(parent);

	    composite.setLayout(new GridLayout());
	    composite.setLayoutData(new GridData(GridData.FILL_BOTH));

	    Composite projectGroup = new Composite(composite, SWT.NONE);
	    GridLayout layout = new GridLayout();
	    layout.numColumns = 1;
	    projectGroup.setLayout(layout);
	    projectGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

	    Label fileNameLabel = new Label(projectGroup, SWT.NONE);
	    fileNameLabel.setText(getLabelText());
	    fileNameLabel.setFont(parent.getFont());

	    fileNameField = new Text(projectGroup, SWT.BORDER);
	    GridData data = new GridData(GridData.FILL_HORIZONTAL);
	    fileNameField.setLayoutData(data);
	    fileNameField.setFont(parent.getFont());
	    
	    fileNameField.addModifyListener(this);
	    
	    setControl(composite);
	    Dialog.applyDialogFont(composite);
	    
	}

	@Override
	public void setVisible(boolean visible) {
		super.setVisible(visible);
		if (visible) {
			fileNameField.setText(getDefaultFileName() +
					(StringUtils.isBlank(getFileExtension()) ? "" : "." + getFileExtension()));
			fileNameField.setFocus();
			fileNameField.setSelection(0, fileNameField.getText().lastIndexOf(getFileExtension()) - 1);
		}
	}
		
	protected boolean isModelNamevalid() {
		if (fileName != null && fileName.endsWith(getFileExtension())) {
			return true;
		} else {
			return false;
		}
	}
	
	@Override
	public void modifyText(ModifyEvent e) {
		Text text = (Text) e.getSource();
		fileName = text.getText(); 
		if (!isModelNamevalid()) {
			setPageComplete(false);
			setErrorMessage(String.format("File name must end with *.%s extension", getFileExtension()));
		} else {
			setErrorMessage(null);
			setPageComplete(true);
		}
	}
	
	public String getModelName() {
		if (fileName == null) {
			return getDefaultFileName() +
					(StringUtils.isBlank(getFileExtension()) ? "" : "." + getFileExtension());
		} else {
			return fileName;
		}
	}
	
	
	/**
	 * Return the message to be shown to the user as a hint about what 
	 * type of information should be entered
	 * 
	 * Clients should override this method
	 * @return
	 */
	protected String getLabelText() {
		return "File name:";
	}
	
	/**
	 * Returns the expected file extension ("" by default)
	 * 
	 * Clients should override this method
	 * @return
	 */
	protected String getFileExtension() {
		return "";
	}
	
	/**
	 * Returns the default file name ("file" by default)
	 * 
	 * Clients should override this method
	 * @return
	 */
	protected String getDefaultFileName() {
		return "file";
	}
}