package es.upv.dsic.issi.dplfw.core.ui.wizards.pages;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.Path;

import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.ui.wizards.NewDocumentConfigurationWizardData;

public class SetDfmconfFileNameWizardPage extends SetFileNameWizardPage {

	private NewDocumentConfigurationWizardData data;
	
	public SetDfmconfFileNameWizardPage(String pageName, String pageTitle, NewDocumentConfigurationWizardData data) {
		super(pageName);
		setTitle(pageTitle);
		setDescription("Enter a Document Feature Model Configuration file name");
		this.data = data;
	}
	
	@Override
	protected String getDefaultFileName() {
		String fileName = "model";
		if (data.getDfmConfFolder() != null) {
			IFolder folder = data.getDfmConfFolder().getFolder();
			while (folder.getFile(new Path(fileName).addFileExtension(IDplProject.DFMCONF_MODEL_EXTENSION)).exists()) {
				Pattern pattern = Pattern.compile("(\\D*)(\\d*)");
				Matcher matcher = pattern.matcher(fileName);
				if (matcher.matches()) {
					String numSequence = matcher.group(2);
					if (StringUtils.isBlank(numSequence)) {
						fileName = matcher.group(1) + "1";
					} else {
						fileName = matcher.group(1) + (Integer.valueOf(numSequence) + 1);
					}
				}
			};
		}
		return fileName;
	}
	
	@Override
	protected String getFileExtension() {
		return IDplProject.DFMCONF_MODEL_EXTENSION;
	}
	
	@Override
	protected String getLabelText() {
		return "Document Feature Model Configuration name:";
	}
	
	@Override
	public boolean isPageComplete() {
		boolean isPageComplete = super.isPageComplete();
		if (isPageComplete) {
			data.setDfmConfFileName(getModelName());
		}
		return isPageComplete;
	}
	
	@Override
	protected boolean isModelNamevalid() {
		if (data.getDfmConfFolder() != null) {
			IFolder folder = data.getDfmConfFolder().getFolder();
			return super.isModelNamevalid() && !folder.getFile(getModelName()).exists();
		}
		return false;
	}
}
