package es.upv.dsic.issi.dplfw.core.ui.wizards.pages;

import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.ui.wizards.NewDplProjectWizardData;

public class SetDfmFileNameWizardPage extends SetFileNameWizardPage {

	private NewDplProjectWizardData data;
	
	public SetDfmFileNameWizardPage(String pageName, String pageTitle, NewDplProjectWizardData data) {
		super(pageName);
		setTitle(pageTitle);
		this.data = data;
	}
	
	@Override
	protected String getDefaultFileName() {
		return "model";
	}
	
	@Override
	protected String getFileExtension() {
		return IDplProject.DFM_MODEL_EXTENSION;
	}
	
	@Override
	protected String getLabelText() {
		return "Document Feature Model name:";
	}
	
	@Override
	public boolean isPageComplete() {
		boolean isPageComplete = super.isPageComplete();
		if (isPageComplete) {
			data.setDfmName(getModelName());
		}
		return isPageComplete;
	}
}
