package es.upv.dsic.issi.dplfw.core.ui.wizards.pages;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

import es.upv.dsic.issi.dplfw.core.ui.filters.HiddenFilesFilter;

abstract class SelectFileWizardPage extends WizardPage implements ISelectionChangedListener{
	
	private IFile selectedFile = null;
	private IStructuredSelection initialSelection;


	public SelectFileWizardPage(String string, StructuredSelection initialSelection) {
		super(string);
		this.initialSelection = initialSelection;
	}

	@Override
	public void createControl(Composite parent) {
	    Composite composite = new Composite(parent, SWT.NULL);
	    
	    initializeDialogUnits(parent);

	    composite.setLayout(new GridLayout());
	    composite.setLayoutData(new GridData(GridData.FILL_BOTH));

	    Label modelNameLabel = new Label(composite, SWT.NONE);
	    modelNameLabel.setText(getLabelText());
	    modelNameLabel.setFont(parent.getFont());
	    modelNameLabel.setData(new GridData(GridData.FILL_HORIZONTAL));
	    
	    TreeViewer viewer = new TreeViewer(composite);
	    viewer.getTree().setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
	    viewer.setContentProvider(new WorkbenchContentProvider());
	    viewer.setLabelProvider(WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
	    viewer.setInput(ResourcesPlugin.getWorkspace());
		viewer.setFilters(new ViewerFilter[] { new HiddenFilesFilter()});
		viewer.addSelectionChangedListener(this);
		viewer.setSelection(initialSelection);
	    
	    // Show description on opening
	    setControl(composite);
	    Dialog.applyDialogFont(composite);
	    
	}
	
	@Override
	public void selectionChanged(SelectionChangedEvent event) {
		IStructuredSelection selection = (IStructuredSelection) event.getSelection();
		IResource resource = (IResource) selection.getFirstElement();
		
		if (!(resource instanceof IFile)) {
			setErrorMessage("Selected resource is not a file");
			setPageComplete(false);
			return;
		} else if (getFileExtension() != null && !getFileExtension().equals(resource.getFileExtension())) {
			setErrorMessage(String.format("Please select a (*.%s) file", getFileExtension()));
			setPageComplete(false);
		} else {
			selectedFile = (IFile) resource;
			setErrorMessage(null);
			setPageComplete(true);
		}
	}
	
	public IFile getSelectedFile() {
		return selectedFile;
	}
	
	/**
	 * Return the message to be shown to the user as a hint about what 
	 * type of resource must be selected
	 * 
	 * Clients should override this method
	 * @return
	 */
	protected String getLabelText() {
		return "Select a file";
	}
	
	/**
	 * Returns the expected file extension (null by default)
	 * 
	 * Clients should override this method
	 * @return
	 */
	protected String getFileExtension() {
		return null;
	}
	
}