package es.upv.dsic.issi.dplfw.core.ui.wizards.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.ui.filters.DplProjectsFilter;
import es.upv.dsic.issi.dplfw.core.ui.wizards.NewDocumentConfigurationWizardData;

public class SelectDplProjectWizardPage extends WizardPage implements ISelectionChangedListener {
	
	private NewDocumentConfigurationWizardData data;	
	private TableViewer viewer;

	public SelectDplProjectWizardPage(String pageName, String pageTitle, NewDocumentConfigurationWizardData data) {
		super(pageName, pageTitle, null);
		setDescription("Select a Document Product Line project");
		this.data = data;
	}

	@Override
	public void createControl(Composite parent) {
		initializeDialogUnits(parent);
		
		// top level group
		Composite topLevel = new Composite(parent, SWT.NONE);
		topLevel.setLayout(new GridLayout());
		topLevel.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		topLevel.setFont(parent.getFont());

		Composite dataComposite = new Composite(topLevel, SWT.NONE);
		dataComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		dataComposite.setLayout(new GridLayout());

		Label projectLabel = new Label(dataComposite, SWT.NONE);
		projectLabel.setText("Select the DPL project:");
		
		Table table = new Table(dataComposite, SWT.BORDER);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		viewer = new TableViewer(table);
		viewer.setContentProvider(new WorkbenchContentProvider());
		viewer.setLabelProvider(WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
		viewer.setInput(ResourcesPlugin.getWorkspace().getRoot());
		viewer.setFilters(new ViewerFilter[] { new DplProjectsFilter()});
		viewer.addSelectionChangedListener(this);
		
		setControl(topLevel);
	}

	@Override
	public void setVisible(boolean visible) {
		super.setVisible(visible);
		if (visible) {
			if (data.getDplProject() != null) {
				viewer.setSelection(new StructuredSelection(data.getDplProject().getProject()));
			} else {
				viewer.setSelection(null);
			}
		}
	}
	
	@Override
	public void selectionChanged(SelectionChangedEvent event) {
		IStructuredSelection selection = (IStructuredSelection) viewer.getSelection();
		if (!selection.isEmpty()) {
			IDplProject dplProject = IDplProject.create((IProject) selection.getFirstElement());
			if (dplProject.getDfmFile() != null && dplProject.getDfmFile().getFile().exists()) {
				data.setDplProject(dplProject);
				if (dplProject.getDfmconfFolders().size() == 1) {
					data.setDfmConfFolder(dplProject.getDfmconfFolders().get(0));
				}
				setErrorMessage(null);
				setPageComplete(true);
			} else {
				setErrorMessage(NLS.bind("Project''{0}'' does not have a default Document Feature Model", dplProject.toString()));
				setPageComplete(false);
			}
		} else {
			setPageComplete(false);
		}
	}
}
