package es.upv.dsic.issi.dplfw.core.ui.wizards.pages;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

import es.upv.dsic.issi.dplfw.core.ui.wizards.NewDocumentConfigurationWizardData;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.provider.DfmItemProviderAdapterFactory;

public class SelectDocumentContextsWizardPage extends WizardPage implements ISelectionChangedListener{
	
	private NewDocumentConfigurationWizardData data;	
	private TableViewer viewer;
	private DocumentFeatureModel dfm;

	public SelectDocumentContextsWizardPage(String pageName, String pageTitle, NewDocumentConfigurationWizardData data) {
		super(pageName, pageTitle, null);
		setDescription("Select a Document Contexts");
		this.data = data;
	}

	@Override
	public void createControl(Composite parent) {
		initializeDialogUnits(parent);
		
		// top level group
		Composite topLevel = new Composite(parent, SWT.NONE);
		topLevel.setLayout(new GridLayout());
		topLevel.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		topLevel.setFont(parent.getFont());

		Composite dataComposite = new Composite(topLevel, SWT.NONE);
		dataComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		dataComposite.setLayout(new GridLayout());

		Label projectLabel = new Label(dataComposite, SWT.NONE);
		projectLabel.setText("Select Document Contexts:");
		
		Table table = new Table(dataComposite, SWT.CHECK | SWT.BORDER);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		viewer = new TableViewer(table);
		viewer.setContentProvider(new ArrayContentProvider());
		viewer.setLabelProvider(new AdapterFactoryLabelProvider(new DfmItemProviderAdapterFactory()));
		viewer.addSelectionChangedListener(this);
		
		setControl(topLevel);
	}

	@Override
	public void selectionChanged(SelectionChangedEvent event) {
		IStructuredSelection selection = (IStructuredSelection) viewer.getSelection();
		data.setSelectedContexts(selection.toList());
	}
	
	@Override
	public void setVisible(boolean visible) {
		super.setVisible(visible);
		if (visible) {
			viewer.setInput(getDfm().getContexts());
			/*viewer.setInput(data.getDplProject().getDfmconfFolders());
			if (data.getDfmConfFolder() != null) {
				viewer.setSelection(new StructuredSelection(data.getDfmConfFolder()));
			}
			*/
		}
	}
	public DocumentFeatureModel getDfm(){
		if (dfm == null) {
			URI uri = data.getDfmFile().getURI();
			ResourceSet resourceSet = new ResourceSetImpl();
			Resource resource = resourceSet.getResource(uri, true);
			dfm = (DocumentFeatureModel) resource.getContents().get(0);
		}
		return dfm;
	}
}