package es.upv.dsic.issi.dplfw.core.ui.wizards.pages;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.model.WorkbenchLabelProvider;

import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.ui.wizards.NewDocumentConfigurationWizardData;

public class SelectDfmConfFolderWizardPage extends WizardPage implements ISelectionChangedListener {
	
	
	private NewDocumentConfigurationWizardData data;	
	private TableViewer viewer;

	public SelectDfmConfFolderWizardPage(String pageName, String pageTitle, NewDocumentConfigurationWizardData data) {
		super(pageName, pageTitle, null);
		setDescription("Select a Configurations folder");
		this.data = data;
	}

	@Override
	public void createControl(Composite parent) {
		initializeDialogUnits(parent);
		
		// top level group
		Composite topLevel = new Composite(parent, SWT.NONE);
		topLevel.setLayout(new GridLayout());
		topLevel.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		topLevel.setFont(parent.getFont());

		Composite dataComposite = new Composite(topLevel, SWT.NONE);
		dataComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		dataComposite.setLayout(new GridLayout());

		Label projectLabel = new Label(dataComposite, SWT.NONE);
		projectLabel.setText("Select the configurations folder:");
		
		Table table = new Table(dataComposite, SWT.BORDER);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		viewer = new TableViewer(table);
		viewer.setContentProvider(new ArrayContentProvider());
		viewer.setLabelProvider(WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
		viewer.addSelectionChangedListener(this);
		
		setControl(topLevel);
	}

	@Override
	public void selectionChanged(SelectionChangedEvent event) {
		IStructuredSelection selection = (IStructuredSelection) viewer.getSelection();
		IDplFolder dplFolder = (IDplFolder) selection.getFirstElement();
		data.setDfmConfFolder(dplFolder);
	}
	
	@Override
	public void setVisible(boolean visible) {
		super.setVisible(visible);
		if (visible) {
			viewer.setInput(data.getDplProject().getDfmconfFolders());
			if (data.getDfmConfFolder() != null) {
				viewer.setSelection(new StructuredSelection(data.getDfmConfFolder()));
			}
		}
	}
}
