package es.upv.dsic.issi.dplfw.core.ui.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.ui.DplfwUiPlugin;
import es.upv.dsic.issi.dplfw.core.ui.wizards.pages.SetDfmFileNameWizardPage;
import es.upv.dsic.issi.dplfw.core.ui.wizards.pages.WizardNewDplProjectCreationPage;



public class NewDplProjectWizard extends DplAbstractWizard {
	
	private static String WIZARD_TITLE = "Document Product Line Project Wizard";

	private NewDplProjectWizardData data = new NewDplProjectWizardData();
	
	public NewDplProjectWizard() {
		setWindowTitle("New Document Product Line Project");
		setNeedsProgressMonitor(true);
	}

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
	}
	
	@Override
	public void addPages() {
		super.addPages();
		
		WizardNewProjectCreationPage page1 = new WizardNewDplProjectCreationPage(
				WizardNewDplProjectCreationPage.class.getName(), WIZARD_TITLE, data);
		page1.setDescription("Create a new Document Product Line project from scratch.");
		
		SetDfmFileNameWizardPage page2 = new SetDfmFileNameWizardPage(
				SetDfmFileNameWizardPage.class.getName(), WIZARD_TITLE, data);
		page2.setDescription("Create a new Document Product Line project from scratch.");

		addPage(page1);
		addPage(page2);
		
	}
	

	@Override
	public boolean performFinish() {
		final String projectName = data.getProjectName();
		final String dfmName = data.getDfmName();
		final URI projectLocation = data.getProjectLocation();
	    try {
			getContainer().run(false, false, new WorkspaceModifyOperation() {
				
				@Override
				protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
					monitor.beginTask("Creating project", 7);
					try {
						// Create project
						monitor.subTask("Creating new project...");
						IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
						IProjectDescription description = project.getWorkspace().newProjectDescription(projectName);
						description.setLocationURI(projectLocation);
						project.create(description, SubMonitor.convert(monitor, 1));
						monitor.subTask("Opening project...");
						project.open(SubMonitor.convert(monitor, 1));
						
						monitor.subTask("Adding DPL nature...");
						addDplNature(project, SubMonitor.convert(monitor, 1));

						monitor.subTask("Initializing Document Feature Model...");
						IDplProject dplProject = IDplProject.create(project);
						IDfmFile dfmFile = dplProject.initializeDfm(dfmName, SubMonitor.convert(monitor, 1));
						
						monitor.subTask("Opening Document Feature model...");
						openFile(dfmFile.getFile());
						monitor.worked(1);
						
						monitor.subTask("Updating Perspective...");
						BasicNewProjectResourceWizard.updatePerspective(config);
						monitor.worked(1);
						monitor.subTask("Selecting Document Feature Model File...");
						selectFile(dfmFile.getFile());
						monitor.worked(1);
						
					} catch (CoreException e) {
						DplfwUiPlugin.log(e);
					} catch (IOException e) {
						DplfwUiPlugin.log(e);
					} finally {
						monitor.done();
					}
				}
			});
			return true;
		} catch (InvocationTargetException e) {
			DplfwUiPlugin.log(e);
		} catch (InterruptedException e) {
			DplfwUiPlugin.log(e);
		}
	    return false;
	}

	public static void addDplNature(IProject project, IProgressMonitor monitor) throws CoreException {
		if (monitor == null) {
			monitor = new NullProgressMonitor();
		}
		try {
			monitor.beginTask("Adding DPL nature", 2);
			if (!project.hasNature(DplfwPlugin.NATURE_ID)) {
				IProjectDescription description = project.getDescription();
				String[] prevNatures= description.getNatureIds();
				String[] newNatures= new String[prevNatures.length + 1];
				System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
				newNatures[prevNatures.length]= DplfwPlugin.NATURE_ID;
				description.setNatureIds(newNatures);
				monitor.worked(1);
				
				project.setDescription(description, SubMonitor.convert(monitor, 1));
			}
		} finally {
			monitor.done();
		}
	}
}
