package es.upv.dsic.issi.dplfw.core.ui.wizards;

import java.util.Collections;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

import es.upv.dsic.issi.dplfw.core.model.IDfmConfFile;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.dfm.DocumentContext;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;

public class NewDocumentConfigurationWizardData {

	private IDplProject dplProject;
	private IDfmFile dfmFile;
	private IDplFolder dfmConfFolder;
	private String dfmConfFileName;
	private List<DocumentContext> selectedContexts;
	
	/**
	 * @return the dplProject
	 */
	public IDplProject getDplProject() {
		return dplProject;
	}

	/**
	 * @param dplProject the dplProject to set
	 */
	public void setDplProject(IDplProject dplProject) {
		this.dplProject = dplProject;
	}

	/**
	 * @return the dfmFile
	 */
	public IDfmFile getDfmFile() {
		return dfmFile != null ? dfmFile : dplProject.getDfmFile();
	}

	/**
	 * @param dfmFile the dfmFile to set
	 */
	public void setDfmFile(IDfmFile dfmFile) {
		this.dfmFile = dfmFile;
	}

	/**
	 * @param dfmConfFile the dfmConfFile to set
	 */
	public void setDfmConfFolder(IDplFolder dplFolder) {
		this.dfmConfFolder = dplFolder;
	}

	/**
	 * @return the dfmConfFolder
	 */
	public IDplFolder getDfmConfFolder() {
		return dfmConfFolder;
	}
	
	/**
	 * @param dfmConfFileName
	 */
	public void setDfmConfFileName(String dfmConfFileName) {
		this.dfmConfFileName = dfmConfFileName;
	}
	
	/**
	 * @return the dfmConfFile
	 */
	public IDfmConfFile getDfmConfFile() {
		if (dfmConfFolder != null && dfmConfFileName != null) {
			IFile file = dfmConfFolder.getFolder().getFile(dfmConfFileName);
			return IDplFile.create(file).as(IDfmConfFile.class);
		} else {
			return null;
		}
	}

	public boolean isComplete() {
		return getDfmConfFile() != null 
				&& getDfmFile() != null 
				&& getDfmFile().getFile().exists() 
				&& getDfmConfFile() != null;
	}
	
	public boolean isDfmContextsEmpty() {
		boolean result = true;
		try {
			URI uri = getDfmFile().getURI();
			ResourceSet resourceSet = new ResourceSetImpl();
			Resource resource = resourceSet.getResource(uri, true);
			resource.load(Collections.emptyMap());
			DocumentFeatureModel dfm = (DocumentFeatureModel) resource.getContents().get(0);
			result = dfm.getContexts().isEmpty();
			resource.unload();
		} catch (Exception e) {
		}
		return result;
	}
	
	public void setSelectedContexts(List<DocumentContext> selectedContexts) {
		this.selectedContexts = selectedContexts;
	}
	
	public List<DocumentContext> getSelectedContexts() {
		return selectedContexts;
	}
}
