package es.upv.dsic.issi.dplfw.core.ui.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.IDfmConfFile;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.ui.DplfwUiPlugin;
import es.upv.dsic.issi.dplfw.core.ui.wizards.pages.SelectDfmConfFolderWizardPage;
import es.upv.dsic.issi.dplfw.core.ui.wizards.pages.SelectDocumentContextsWizardPage;
import es.upv.dsic.issi.dplfw.core.ui.wizards.pages.SelectDplProjectWizardPage;
import es.upv.dsic.issi.dplfw.core.ui.wizards.pages.SetDfmconfFileNameWizardPage;
import es.upv.dsic.issi.dplfw.dfm.DocumentContext;
import es.upv.dsic.issi.dplfw.dfmconf.exceptions.FeatureModelNotFoundException;

public class NewDocumentConfigurationWizard extends DplAbstractWizard {

	private static String WIZARD_TITLE = "New configuration";

	private NewDocumentConfigurationWizardData data = new NewDocumentConfigurationWizardData();
	
	private SelectDplProjectWizardPage selProjectPage;
	private SelectDfmConfFolderWizardPage selFolderPage;
	private SetDfmconfFileNameWizardPage selFileNamePage;
	private SelectDocumentContextsWizardPage selDocumentContextsPage;
	
	public NewDocumentConfigurationWizard() {
		setWindowTitle("New Document Feature Model Configuration");
		setNeedsProgressMonitor(true);
	}

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		if (selection.size() == 1) {
			if (selection.getFirstElement() instanceof IResource) {
				IResource resource = (IResource) selection.getFirstElement();
				IProject project = resource.getProject();
				try {
					if (project.hasNature(DplfwPlugin.NATURE_ID)) {
						data.setDplProject(IDplProject.create(project));
					}
				} catch (CoreException e) {
					DplfwUiPlugin.log(e);
				}
			}
		}
	}
	
	@Override
	public boolean performFinish() {
		final IDfmConfFile dfmConfFile = data.getDfmConfFile();
		final IDfmFile dfmFile = data.getDfmFile();
		final List<DocumentContext> contexts = data.getSelectedContexts();
	    try {
			getContainer().run(false, false, new WorkspaceModifyOperation() {
				@Override
				protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
					monitor.beginTask("Creating Document Feature Model Configuration", 4);
					try {
						monitor.subTask("Initializing configuration");
						dfmConfFile.initialize(dfmFile, contexts, SubMonitor.convert(monitor, 1));
						monitor.subTask("Opening file");
						openFile(dfmConfFile.getFile());
						monitor.worked(1);
						monitor.subTask("Updating perspective");
						BasicNewProjectResourceWizard.updatePerspective(config);
						monitor.worked(1);
						monitor.subTask("Selecting file");
						selectFile(dfmConfFile.getFile());
						monitor.worked(1);
					} catch (IOException e) {
						DplfwUiPlugin.log(e);
					} catch (PartInitException e) {
						DplfwUiPlugin.log(e);
					} catch (CoreException e) {
						DplfwUiPlugin.log(e);
					} catch (FeatureModelNotFoundException e) {
						DplfwUiPlugin.log(e);
					} finally {
						monitor.done();
					}
				}
			});
			return true;
		} catch (InvocationTargetException e) {
			DplfwUiPlugin.log(e.getTargetException());
		} catch (InterruptedException e) {
			DplfwUiPlugin.log(e);
		}

		return true;
	}

	@Override
	public void addPages() {
		super.addPages();

		selProjectPage = new SelectDplProjectWizardPage(
				SelectDplProjectWizardPage.class.getName(), WIZARD_TITLE, data);
		
		selFolderPage = new SelectDfmConfFolderWizardPage(
				SelectDfmConfFolderWizardPage.class.getName(), WIZARD_TITLE, data);
		
		selFileNamePage = new SetDfmconfFileNameWizardPage(
				SetDfmconfFileNameWizardPage.class.getName(), WIZARD_TITLE, data);

		selDocumentContextsPage = new SelectDocumentContextsWizardPage(
				SelectDocumentContextsWizardPage.class.getName(), WIZARD_TITLE, data);

		addPage(selProjectPage);
		addPage(selFolderPage);
		addPage(selDocumentContextsPage);
		addPage(selFileNamePage);
	}

	@Override
	public IWizardPage getNextPage(IWizardPage page) {
		if (page.equals(selProjectPage) && data.getDfmConfFolder() != null) {
			if (!data.isDfmContextsEmpty()) {
				return selDocumentContextsPage;
			} else {
				return selFileNamePage;
			}
		} else if (page.equals(selFolderPage)) {
			if (!data.isDfmContextsEmpty()) {
				return selDocumentContextsPage;
			} else {
				return selFileNamePage;
			}
		}
		return super.getNextPage(page);
	}

	@Override
	public boolean canFinish() {
		return super.canFinish() && data.isComplete();
	}
	
}
