package es.upv.dsic.issi.dplfw.core.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public abstract class DplAbstractWizard extends Wizard implements INewWizard, IExecutableExtension  {

	protected IConfigurationElement config;

	public DplAbstractWizard() {
		super();
	}
	
	@Override
	public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
		this.config = config;
	}


	/**
	 * Selects the given file in any visible viewer
	 * @param file
	 */
	protected static void selectFile(IFile file) {
		IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
		// Try to select the new file in the available views of the workbench
		// We do this in a generic way (iterating) to select the file in any possible 
		// view (project explorer, dpl explorer, etc...)
		for (IViewReference viewReference : page.getViewReferences()) {
			final IViewPart viewPart = viewReference.getView(false);
			if (viewPart instanceof ISetSelectionTarget) {
				final ISelection targetSelection = new StructuredSelection(file);
				((ISetSelectionTarget) viewPart).selectReveal(targetSelection);
				viewPart.getViewSite().getShell().getDisplay().asyncExec
				(new Runnable() {
					 public void run() {
						 ((ISetSelectionTarget)viewPart).selectReveal(targetSelection);
					 }
				 });
			}
		}
	}

	/**
	 * Opens the given file with its default editor
	 * @param file
	 * @throws PartInitException
	 */
	protected static void openFile(IFile file) throws PartInitException {
		IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
		// Open the new file in its default editor
		IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
		page.openEditor(new FileEditorInput(file), desc.getId());
	}


}