package es.upv.dsic.issi.dplfw.core.ui.views;

import java.io.IOException;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

import es.upv.dsic.issi.dplfw.core.ui.DplfwUiPlugin;
import es.upv.dsic.issi.dplfw.core.ui.util.SWTUtil;

public class Dashboard extends ViewPart {

	private Composite composite;
	private Label imageLabel;
	// baseImage MUST be disposed!!
	private Image baseImage;

	@Override
	public void init(IViewSite site) throws PartInitException {
		super.init(site);
		try {
			baseImage = new Image(site.getShell().getDisplay(),
					FileLocator.openStream(DplfwUiPlugin.getDefault().getBundle(), new Path("/icons/dplfw_overview.png"), false));
		} catch (IOException e) {
			DplfwUiPlugin.log(e);
		}

	}
	
	@Override
	public void createPartControl(Composite parent) {
		composite = new Composite(parent, SWT.NONE);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		composite.setBackground(getSite().getShell().getDisplay().getSystemColor(SWT.COLOR_WHITE));
		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		layout.marginHeight = 0;
		composite.setLayout(layout);
		
		imageLabel = new Label(composite, SWT.NONE);
		imageLabel.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, true, true));

		composite.addListener(SWT.Resize, new Listener() {
			@Override
			public void handleEvent(Event event) {
				float imgW = baseImage.getBounds().width;
				float imgH = baseImage.getBounds().height;
				float cmpW = composite.getSize().x;
				float cmpH = composite.getSize().y;

				
				float imgRatio = imgW / imgH;
				float cmpRatio = cmpW / cmpH;

				int width = (int) cmpW;
				int height = (int) cmpH;
				
				if (imgRatio > cmpRatio) {
					width = (int) cmpW;
					height = (int) (cmpW / imgRatio);
				} else {
					width = (int) (cmpH * imgRatio);
					height = (int) cmpH;
				}
				
				int lastW = 0;
				int lastH = 0;
				if (imageLabel.getImage() != null) {
					// Previous image was manually created and must be disposed!
					lastW = imageLabel.getImage().getBounds().width;
					lastH = imageLabel.getImage().getBounds().height;
				}
				if (lastW != width || lastH != height ) {
					if (imageLabel.getImage() != null) {
						imageLabel.getImage().dispose();
					}
					Image image = SWTUtil.createResizedImage(baseImage, width, height);
					imageLabel.setImage(image);
				}	
				composite.layout(true, true);
			}
		});
	}

	
	@Override
	public void setFocus() {
	}
	
	@Override
	public void dispose() {
		baseImage.dispose();
		baseImage = null;
		super.dispose();
	}
}
