package es.upv.dsic.issi.dplfw.core.ui.project.properties;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.IDfmFile;
import es.upv.dsic.issi.dplfw.core.model.IDplFile;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.ui.filters.DfmFilesFilter;
import es.upv.dsic.issi.dplfw.core.ui.filters.DfmFoldersFilter;
import es.upv.dsic.issi.dplfw.core.ui.filters.HiddenFilesFilter;

public class DplfwDfmPropertyPage extends PropertyPage implements ISelectionChangedListener, SelectionListener {

	private TreeViewer viewer;
	DfmFoldersFilter dfmFoldersFilter = new DfmFoldersFilter();
	DfmFilesFilter dfmFilesFilter = new DfmFilesFilter();
	HiddenFilesFilter hiddenFilesFilter = new HiddenFilesFilter();
	private Button button;
	
	/**
	 * Constructor for SamplePropertyPage.
	 */
	public DplfwDfmPropertyPage() {
		super();
		noDefaultAndApplyButton();
	}


	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayoutData(new GridData(GridData.FILL, GridData.FILL, true, true));
		GridLayout compositeLayout = new GridLayout();
		compositeLayout.marginWidth = 0;
		compositeLayout.marginHeight = 0;
		composite.setLayout(compositeLayout);

		Label viewerLabel = new Label(composite, SWT.NONE);
		viewerLabel.setLayoutData(new GridData());
		viewerLabel.setText("Select the Document Feature Model of the project:");
		
		Tree tree = new Tree(composite, SWT.SINGLE | SWT.BORDER);
		tree.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		
		viewer = new TreeViewer(tree);
		viewer.setContentProvider(new WorkbenchContentProvider());
		viewer.setLabelProvider(WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
		viewer.setAutoExpandLevel(AbstractTreeViewer.ALL_LEVELS);
		viewer.setInput(IDplProject.create(getProject()).getDfmFolder().getFolder().getParent());
		viewer.addSelectionChangedListener(this);
		
		button = new Button(composite, SWT.CHECK);
		button.setText("Show only the default document feature model folder");
		viewer.setFilters(new ViewerFilter[] { dfmFoldersFilter, dfmFilesFilter, hiddenFilesFilter});
		button.addSelectionListener(this);
		button.setSelection(true);
		
		try {
			initializeUiContents();
		} catch (CoreException e) {
		}
		
		return composite;
	}
	
	@Override
	public void selectionChanged(SelectionChangedEvent event) {
		IStructuredSelection selection = (IStructuredSelection) event.getSelection();
		IResource resource = (IResource) selection.getFirstElement();
		if (IDplFile.isDfmFile(resource)) {
			setValid(true);
			setErrorMessage(null);
		} else {
			setValid(false);
			setErrorMessage(String.format("Select a valid Document Feature Model (*.%s)", IDplProject.DFM_MODEL_EXTENSION));
		}
	}
	
	@Override
	public void widgetSelected(SelectionEvent e) {
		if (e.getSource().equals(button)) {
			Button button = (Button) e.getSource();
			ISelection selection = viewer.getSelection();
			if (button.getSelection()) {
				viewer.setInput(IDplProject.create(getProject()).getDfmFolder().getFolder().getParent());
				viewer.setFilters(new ViewerFilter[] { dfmFoldersFilter, dfmFilesFilter, hiddenFilesFilter});
			} else {
				viewer.setInput(getProject());
				viewer.setFilters(new ViewerFilter[] { dfmFilesFilter, hiddenFilesFilter});
			}
			viewer.setSelection(selection);
		}
	}
	
	
	@Override
	public void widgetDefaultSelected(SelectionEvent e) {
	}

	
	protected void initializeUiContents() throws CoreException {
		IProject project = (IProject) getElement().getAdapter(IProject.class);
		if (project.hasNature(DplfwPlugin.NATURE_ID)) {
			IDplProject dplProject = IDplProject.create(project);
			IDfmFile dfmFile = dplProject.getDfmFile();
			if (dfmFile != null) {
				IFile file = dfmFile.getFile();
				IStructuredSelection selection = new StructuredSelection(file);
				viewer.setSelection(selection);
			}
		}
	}

	public boolean performOk() {
		IStructuredSelection selection = (IStructuredSelection) viewer.getSelection();
		IFile file = (IFile) selection.getFirstElement();
		IProject project = getProject();
		try {
			if (project.hasNature(DplfwPlugin.NATURE_ID)) {
				IDplProject dplProject = IDplProject.create(project);
				IDfmFile dfmFile = (IDfmFile) IDplFile.create(file);
				dplProject.setDfmFile(dfmFile);
			}
			return true;
		} catch (CoreException e) {
		}
		return false;
	}
	

	protected IProject getProject() {
		return (IProject) getElement().getAdapter(IProject.class);
	}


}