package es.upv.dsic.issi.dplfw.core.ui.popup.actions;

import java.io.IOException;
import java.util.Collections;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import es.upv.dsic.issi.dplfw.core.ui.DplfwUiPlugin;
import es.upv.dsic.issi.dplfw.core.util.TransformerUtil;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration;
import es.upv.dsic.issi.dplfw.wfm.Process;

public class GenerateWfm implements IObjectActionDelegate {

	private IFile file;

	/**
	 * Constructor for Action1.
	 */
	public GenerateWfm() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		Job job = new Job("Generate WFM") {
			@Override
			protected IStatus run(IProgressMonitor monitor) {
				
				ResourceSet resourceSet = new ResourceSetImpl();

				Resource dfmcResource = resourceSet.getResource(
						URI.createPlatformResourceURI(file.getFullPath().toString(), false), true);
				Resource wfmResource = resourceSet.createResource(
						URI.createPlatformResourceURI(file.getFullPath().removeFileExtension().addFileExtension("wfm").toString(), false));
				
				try {

					dfmcResource.load(Collections.EMPTY_MAP);
					
					DocumentFeatureModelConfiguration dfmc = (DocumentFeatureModelConfiguration) dfmcResource.getContents().get(0);
					
					Process process = TransformerUtil.transformDfmconfToProcess(dfmc); 
					
					wfmResource.getContents().add(process);
					wfmResource.save(Collections.emptyMap());
					
				} catch (IOException e) {
					DplfwUiPlugin.log(e);
				}
				
				return Status.OK_STATUS;
			}
		};
		job.schedule();
	}

	
	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			if (((IStructuredSelection) selection).getFirstElement() instanceof IFile) {
				file = (IFile) ((IStructuredSelection) selection).getFirstElement();
			}
		}
	}

}
