package es.upv.dsic.issi.dplfw.core.ui.popup.actions;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import es.upv.dsic.issi.dplfw.core.ui.DplfwUiPlugin;
import es.upv.dsic.issi.dplfw.core.util.TransformerUtil;
import es.upv.dsic.issi.dplfw.wfm.Activity;
import es.upv.dsic.issi.dplfw.wfm.FlowNode;
import es.upv.dsic.issi.dplfw.wfm.Process;

public class GenerateDita implements IObjectActionDelegate {

	private IFile file;

	/**
	 * Constructor for Action1.
	 */
	public GenerateDita() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		Job job = new Job("Generate DITA") {
			@Override
			protected IStatus run(IProgressMonitor monitor) {
				monitor.beginTask("Generating DITA resources", IProgressMonitor.UNKNOWN);
				IFolder destinationFolder = file.getProject().getFolder("resources");
				ResourceSet resourceSet = new ResourceSetImpl();
				Resource wfmResource = resourceSet.getResource(URI.createPlatformResourceURI(file.getFullPath().toString(), false), true);
				try {
					wfmResource.load(Collections.EMPTY_MAP);
					EcoreUtil.resolveAll(wfmResource);
					Process process = (Process) wfmResource.getContents().get(0);
					if (!isProcessApproved(process)) {
						AtomicBoolean cont = new AtomicBoolean(false);
						Display.getDefault().syncExec(new Runnable() {
							@Override
							public void run() {
								 cont.set(MessageDialog.openQuestion(Display.getDefault().getActiveShell(),
											"Continue?",
											"Not all the activities of the process have been approved. Do you really want to continue?"));	
							}
						});
						if (!cont.get()) {
							return Status.CANCEL_STATUS;
						}
					}
					TransformerUtil.generateDita(process, new File(destinationFolder.getLocationURI()));

					destinationFolder.refreshLocal(IResource.DEPTH_INFINITE, SubMonitor.convert(monitor));
					
				} catch (IOException | CoreException e) {
					DplfwUiPlugin.log(e);
				}
				monitor.done();
				return Status.OK_STATUS;
			}
			
		};
		job.schedule();
	}

	protected boolean isProcessApproved(Process process) {
		Stack<Activity> activities = new Stack<Activity>();
		activities.push(process);
		while (!activities.empty()) {
			Activity activity = activities.pop();
			if (activity != process && !activity.isAproved()) {
				return false;
			} 
			if (activity instanceof Process) {
				Process activityProcess = (Process) activity;
				for (FlowNode node : activityProcess.getNodes()) {
					if (node instanceof Activity) {
						activities.add((Activity) node);
					}
				}
			}
		}
		return true;
	}
	
	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			if (((IStructuredSelection) selection).getFirstElement() instanceof IFile) {
				file = (IFile) ((IStructuredSelection) selection).getFirstElement();
			}
		}
	}

}
