package es.upv.dsic.issi.dplfw.core.ui.navigators;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonNavigator;

import es.upv.dsic.issi.dplfw.core.model.IDplFile;
import es.upv.dsic.issi.dplfw.core.ui.DplfwUiPlugin;


//public class DplNavigator extends ResourceNavigator {
public class DplNavigator extends CommonNavigator {
// The CommonNavigator API should be used instead, however, the new wizard 
// context menu is populated without grouping project wizards and file wizards
// To save effort we inherit from the old ResourceNavigator
	
	public static final String VIEW_ID = "es.upv.dsic.issi.dplfw.ui.dplnavigator";

	IResourceChangeListener listener = new IResourceChangeListener() {
		IResourceDeltaVisitor visitor = new IResourceDeltaVisitor() {
			@Override
			public boolean visit(final IResourceDelta delta) throws CoreException {
				final IResource resource = delta.getResource();
				Display display = getSite().getShell().getDisplay();
				display.asyncExec(new Runnable() {
					@Override
					public void run() {
						if (delta.getKind() != IResourceDelta.CHANGED) {
							getCommonViewer().refresh();
						} if (resource instanceof IFile &&
								IDplFile.isDplProjectPreferences((IFile) resource)) {
							getCommonViewer().refresh();
						} else {
							getCommonViewer().update(resource, null);
						}
					}
				});
				return true;
			}
		};
		@Override
		public void resourceChanged(IResourceChangeEvent event) {
			try { 
				if (event.getDelta() != null) { 
					event.getDelta().accept(visitor);
				}
			} catch (CoreException e) {
				DplfwUiPlugin.log(e);
			}
		}
	};

	public DplNavigator() {
		ResourcesPlugin.getWorkspace().addResourceChangeListener(listener);
	}

	@Override
	public void dispose() {
		ResourcesPlugin.getWorkspace().removeResourceChangeListener(listener);
		super.dispose();
	}
}
