package es.upv.dsic.issi.dplfw.core.ui.filters;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;

/**
 * Filter which shows DFM folders and discards other folders
 * Any other element is shown
 * @author agomez
 *
 */
public class DfmFoldersFilter extends ViewerFilter {
	@Override
	public boolean select(Viewer viewer, Object parentElement, Object element) {
		if (element instanceof IFolder) {
			IFolder folder = (IFolder) element;
			IProject project = folder.getProject();
			try {
				if (project.hasNature(DplfwPlugin.NATURE_ID)) {
					IDplProject dplProject = IDplProject.create(project);
					return dplProject.isDfmFolder(IDplFolder.create(folder));
				}
			} catch (CoreException e) {
			}
		} 
		return true;
	}
}