package es.upv.dsic.issi.dplfw.core.ui.filters;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

import es.upv.dsic.issi.dplfw.core.model.IDplFile;

/**
 * Filter which shows DFM files and discards other files
 * Other elements are shown
 * @author agomez
 *
 */
public class DfmFilesFilter extends ViewerFilter {
	@Override
	public boolean select(Viewer viewer, Object parentElement, Object element) {
		if (element instanceof IFile) {
			IFile file = (IFile) element;
			if (IDplFile.isDfmFile(file)) {
				return true;
			} else {
				return false;
			}
		}
		return true;
	}
}