package es.upv.dsic.issi.dplfw.core.ui.decorators;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

import es.upv.dsic.issi.dplfw.core.ui.DplfwUiPlugin;

public class ProblemDecorator implements ILightweightLabelDecorator {

	@Override
	public void addListener(ILabelProviderListener listener) {
	}

	@Override
	public void dispose() {
	}

	@Override
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	@Override
	public void removeListener(ILabelProviderListener listener) {

	}

	@Override
	public void decorate(Object element, IDecoration decoration) {
		IResource resource = (IResource) element;
		if (!resource.isAccessible())
			return;
		try {
			int maxSeverity = resource.findMaxProblemSeverity(IMarker.PROBLEM, true, IResource.DEPTH_INFINITE);
			if (maxSeverity == IMarker.SEVERITY_ERROR) {
				decoration.addOverlay(
						DplfwUiPlugin.getDefault().getImageRegistry().getDescriptor(DplfwUiPlugin.ERROR_OVERLAY),
						IDecoration.BOTTOM_LEFT);
			} else if (maxSeverity == IMarker.SEVERITY_WARNING) {
				decoration.addOverlay(
						DplfwUiPlugin.getDefault().getImageRegistry().getDescriptor(DplfwUiPlugin.WARNING_OVERLAY),
						IDecoration.BOTTOM_LEFT);
			}
		} catch (CoreException e) {
			DplfwUiPlugin.log(e);
		}
	}
	
}
