package es.upv.dsic.issi.dplfw.core.ui.decorators;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

import es.upv.dsic.issi.dplfw.core.DplfwPlugin;
import es.upv.dsic.issi.dplfw.core.model.IDplFolder;
import es.upv.dsic.issi.dplfw.core.model.IDplProject;
import es.upv.dsic.issi.dplfw.core.ui.DplfwUiPlugin;

public class DplFolderDecorator implements ILightweightLabelDecorator {

	@Override
	public void addListener(ILabelProviderListener listener) {
	}

	@Override
	public void dispose() {
	}

	@Override
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	@Override
	public void removeListener(ILabelProviderListener listener) {

	}

	@Override
	public void decorate(Object element, IDecoration decoration) {
		if (element instanceof IAdaptable) {
			IResource resource = (IResource) ((IAdaptable) element).getAdapter(IResource.class);
			if (resource == null || !resource.isAccessible())
				return;
			try {
				if (resource instanceof IFolder) {
					IDplFolder dplFolder = IDplFolder.create((IFolder) resource);
					IProject project = dplFolder.getFolder().getProject();
					if (project != null && project.hasNature(DplfwPlugin.NATURE_ID)) {
						// We use an if instead of handling the CoreException of getNature to prevent
						// an overhead caused by the exception management
						IDplProject dplProject = IDplProject.create(project);
						if (dplProject.isDfmFolder(dplFolder)) {
							decoration.addOverlay(
									DplfwUiPlugin.getDefault().getImageRegistry().getDescriptor(DplfwUiPlugin.MODEL_FOLDER_OVERLAY),
									IDecoration.TOP_RIGHT);
						} else if (dplProject.isDfmconfFolder(dplFolder)) {
							decoration.addOverlay(
									DplfwUiPlugin.getDefault().getImageRegistry().getDescriptor(DplfwUiPlugin.CONFIGS_FOLDER_OVERLAY),
									IDecoration.TOP_RIGHT);
						} else if (dplProject.isWfmFolder(dplFolder)) {
							decoration.addOverlay(
									DplfwUiPlugin.getDefault().getImageRegistry().getDescriptor(DplfwUiPlugin.WORKFLOWS_FOLDER_OVERLAY),
									IDecoration.TOP_RIGHT);
						} else if (dplProject.isResourcesFolder(dplFolder)) {
							decoration.addOverlay(
									DplfwUiPlugin.getDefault().getImageRegistry().getDescriptor(DplfwUiPlugin.RESOURCES_FOLDER_OVERLAY),
									IDecoration.TOP_RIGHT);
						} else if (dplProject.isOuputFolder(dplFolder)) {
							decoration.addOverlay(
									DplfwUiPlugin.getDefault().getImageRegistry().getDescriptor(DplfwUiPlugin.OUTPUT_FOLDER_OVERLAY),
									IDecoration.TOP_RIGHT);
						}
					}
				}
			} catch (CoreException e) {
				DplfwUiPlugin.log(e);
			}
		} 
	}
	
}
