package es.upv.dsic.issi.dplfw.core.ui;

import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class DplfwUiPlugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "es.upv.dsic.issi.dplfw.core.ui"; //$NON-NLS-1$

	// The DPLfw root preferences page ID 
	public static final String PREFERENCES_ROOT_ID = "es.upv.dsic.issi.dplfw.core.ui.preferences.root"; //$NON-NLS-1$

	// The shared instance
	private static DplfwUiPlugin plugin;

	// Image overlay constants
	public static final String ERROR_OVERLAY = "ERROR_OVERLAY";
	public static final String WARNING_OVERLAY = "WARNING_OVERLAY";
	public static final String MODEL_FOLDER_OVERLAY = "MODEL_FOLDER_OVERLAY";
	public static final String CONFIGS_FOLDER_OVERLAY = "CONFIGS_FOLDER_OVERLAY";
	public static final String WORKFLOWS_FOLDER_OVERLAY = "WORKFLOWS_FOLDER_OVERLAY";
	public static final String RESOURCES_FOLDER_OVERLAY = "RESOURCES_FOLDER_OVERLAY";
	public static final String OUTPUT_FOLDER_OVERLAY = "OUTPUT_FOLDER_OVERLAY";

	ILogListener logListener = new ILogListener() {
		@Override
		public void logging(IStatus status, String plugin) {
			StatusManager.getManager().handle(status, StatusManager.BLOCK);
		}
	};
	
	/**
	 * The constructor
	 */
	public DplfwUiPlugin() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
		plugin.getLog().addLogListener(logListener);
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		plugin.getLog().removeLogListener(logListener);
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static DplfwUiPlugin getDefault() {
		return plugin;
	}

	/**
	 * Logs the given exception as an error in the plugin's default logger
	 * This method is provided as a shortcut to 
	 * <code>getDefault().getLog().log(new Status(IStatus.ERROR, PLUGIN_ID, e.getLocalizedMessage(), e));</code>
	 * and should not be called by other plugin's code
	 * @param throwable the exception
	 */
	public static void log(Throwable t) {
		getDefault().getLog().log(new Status(IStatus.ERROR, PLUGIN_ID, t.getLocalizedMessage(), t));
	}
	
	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	protected static ImageDescriptor getImageDescriptor(String path) {
		return imageDescriptorFromPlugin(PLUGIN_ID, path);
	}
	
	@Override
	protected void initializeImageRegistry(ImageRegistry reg) {
		super.initializeImageRegistry(reg);
		reg.put(ERROR_OVERLAY, getImageDescriptor("icons/full/ovr16/error_co.gif").createImage());
		reg.put(WARNING_OVERLAY, getImageDescriptor("icons/full/ovr16/warning_co.gif").createImage());
		reg.put(MODEL_FOLDER_OVERLAY, getImageDescriptor("icons/full/ovr16/model_folder_co.png").createImage());
		reg.put(CONFIGS_FOLDER_OVERLAY, getImageDescriptor("icons/full/ovr16/config_folder_co.png").createImage());
		reg.put(WORKFLOWS_FOLDER_OVERLAY, getImageDescriptor("icons/full/ovr16/workflows_folder_co.png").createImage());
		reg.put(RESOURCES_FOLDER_OVERLAY, getImageDescriptor("icons/full/ovr16/resources_folder_co.png").createImage());
		reg.put(OUTPUT_FOLDER_OVERLAY, getImageDescriptor("icons/full/ovr16/output_folder_co.png").createImage());
	}
}
